public class XmlAssemblyExtension : XmlPartExtension
{
  private Assembly assembly;

  public XmlAssemblyExtension(Assembly assembly)
  {
    this.assembly = assembly;
  }

  public override XmlElement XmlElement
  {
    get
    {
      XmlElement e = NewElement("Element");
      e.AppendChild(NewTextElement("Numer czci", assembly.PartNumber));
      e.AppendChild(NewTextElement("Opis", assembly.Description));

      XmlElement parts = NewElement("Czci");
      foreach(Part part in assembly.Parts)
      {
        XmlPartExtension xpe = part.GetExtension("XML") as XmlPartExtension;
        parts.AppendChild(xpe.XmlElement);
      }
      e.AppendChild(parts);

      return e;
    }
  }
}
